﻿<%@ Page Title="Lab Kit Details" Language="C#" MasterPageFile="~/Custom/EFR/Efr.Master" AutoEventWireup="True" CodeBehind="LabKitInProcessOrders.aspx.cs" Inherits="VIRP_WEB.Custom.EFR.LabKitInProcessOrders" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" Runat="Server">
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" Runat="Server">

    <script type = "text/javascript">

        $(document).ready(function() {
            if ($('select.criteria').length > 0) {
                if ($('select.criteria').find(":selected").val() == "") {
                    $('#<%= ButtonSearch.ClientID %>').attr('disabled', 'disabled');
                    $('#ButtonClear').attr('disabled', 'disabled');

                    $("#<%= TextBoxSearchCriteria.ClientID%>").hide();
                    $("#<%= DropDownListFacility.ClientID%>").hide();
                }
                else {
                    $('#<%= ButtonSearch.ClientID %>').removeAttr('disabled');
                    $('#ButtonClear').removeAttr('disabled');

                    if ($('select.criteria').find(":selected").val() == "LAST_NAME") {
                        $("#<%= TextBoxSearchCriteria.ClientID%>").show();
                        $("#<%= DropDownListFacility.ClientID%>").hide();
                    }
                    else if ($('select.criteria').find(":selected").val() == "FACILITY") {
                        $("#<%= TextBoxSearchCriteria.ClientID%>").hide();
                        $("#<%= DropDownListFacility.ClientID%>").show();
                    }
                }

            }

            $('select.criteria').change(function() {

                $('#<%= TextBoxSearchCriteria.ClientID %>').val('');
                $('#<%= DropDownListFacility.ClientID%>').val('');

                if ($(this).val() == "") {
                    $('#<%= ButtonSearch.ClientID %>').attr('disabled', 'disabled');
                    $('#ButtonClear').attr('disabled', 'disabled');

                    $("#<%= TextBoxSearchCriteria.ClientID%>").hide();
                    $("#<%= DropDownListFacility.ClientID%>").hide();
                }
                else {
                    $('#<%= ButtonSearch.ClientID %>').removeAttr('disabled');
                    $('#ButtonClear').removeAttr('disabled');

                    if ($(this).val() == "LAST_NAME") {
                        $("#<%= TextBoxSearchCriteria.ClientID%>").show();
                        $("#<%= DropDownListFacility.ClientID%>").hide();
                    }
                    else if ($(this).val() == "FACILITY") {
                        $("#<%= TextBoxSearchCriteria.ClientID%>").hide();
                        $("#<%= DropDownListFacility.ClientID%>").show();
                    }
                }

            });

        });

        function ClearSearchCriteria() {
            control = document.getElementById("<%= TextBoxSearchCriteria.ClientID %>");
            if (control != null) {
                control.value = "";
            }
            control = document.getElementById("<%= DropDownListFacility.ClientID %>");
            if (control != null) {
                control.value = "";
            }
        }

    </script>
    
     <div class = "excludeSaveWarnings">
        <br />
        <asp:Label SkinID="DataLabel" ID="LabelSearchCriteria" runat="server" 
            AssociatedControlID="TextBoxSearchCriteria">
            Filter by:
        </asp:Label>
        <asp:DropDownList ID="DropDownFilterBy" runat="server" CssClass = "criteria">
            <asp:ListItem Selected="True" 
                Text="(Select value)" 
                value="">
            </asp:ListItem>
            <asp:ListItem 
                Text="Last Name" 
                value="LAST_NAME">
            </asp:ListItem>
            <asp:ListItem 
                Text="Site/Facility" 
                value="FACILITY">
            </asp:ListItem>
        </asp:DropDownList>
         
        <asp:TextBox ID="TextBoxSearchCriteria" runat="server" Width="200px"></asp:TextBox>
        <asp:DropDownList ID="DropDownListFacility"  
            runat="server" Width="500px" CssClass = "criteriaFacility" DataSourceID="ObjectDataSourceVAMCs"
            AppendDataBoundItems="true" DataTextField="Value" DataValueField="Key">
            <asp:ListItem Value="" Text="(Type to Search)" Selected="True"></asp:ListItem>
        </asp:DropDownList>

        <ajax:ListSearchExtender ID="ListSearchExtenderFacility" QueryTimeout="2000"
            runat="server" TargetControlID="DropDownListFacility" PromptCssClass="lse"
            QueryPattern="Contains">
        </ajax:ListSearchExtender>
        &nbsp;
        &nbsp;
        <asp:Button ID="ButtonSearch" runat="server" Text=" &nbsp;&nbsp;Go&nbsp;&nbsp; " OnClick = "ButtonOK_Click"
            />
        &nbsp;
        <asp:Button ID="ButtonClear" runat="server" Text=" Clear " 
             onclick="ButtonClear_Click" OnClientClick="javascript:ClearSearchCriteria()"  />
    </div>    
    <br />
    <asp:GridView ID="GridViewLabKitOrders" runat="server" 
        AutoGenerateColumns="False" 
        DataSourceID="ObjectDataSourceLabKitOrders" 
        AllowPaging="True"  
        AllowSorting="true"
        DataKeyNames="ActivityId" 
        OnRowCommand="SelectActivity"
        CssClass="gridRegistry">
        <Columns>
            <asp:TemplateField HeaderText="Workflow ID" SortExpression="WkfCaseId">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="Label0" runat="server"
                        Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(DataBinder.Eval(Container.DataItem,"WkfCaseId"))) %>'>
                    </asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Used Stock" SortExpression="FromStock" Visible = "false">
                <ItemTemplate>
                    <asp:CheckBox ID="CheckBoxFromStock" runat="server" 
                        Checked='<%# Bind("FromStock") %>' 
                        Enabled="false" />
                </ItemTemplate>
            </asp:TemplateField>
                <asp:TemplateField HeaderText="Patient Name" SortExpression="PatientName">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="Label1" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(DataBinder.Eval(Container.DataItem, "PatientName"))) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Site Number" SortExpression="StationNumber">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="Label2" runat="server" Text='<%#VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(DataBinder.Eval(Container.DataItem, "StationNumber"))) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Sending Facility" SortExpression="InstName">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="Label2" runat="server" Text='<%#VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(DataBinder.Eval(Container.DataItem, "InstName"))) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="City" SortExpression="City">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="Label3" runat="server" Text='<%#VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(DataBinder.Eval(Container.DataItem, "City"))) %>'></asp:Label>
                </ItemTemplate>        
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Contact Person" SortExpression="VAMCContactNm">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="Label4" runat="server" Text='<%#VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(DataBinder.Eval(Container.DataItem, "VAMCContactNm"))) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Kit Type" SortExpression="KitType">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="Label5" runat="server" Text='<%#VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(DataBinder.Eval(Container.DataItem, "KitType"))) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Date Contacted" SortExpression="KitOrderedDate">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="Label6" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(DisplayFormatOrderedDate(Eval("KitOrderedDate") as DateTime?)) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Received Date" SortExpression="ReceivedDate">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="Label8" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("ReceivedDate", "{0:M/d/yyyy}"))) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Status" SortExpression="Status">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="Label7" runat="server" Text='<%#VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(DataBinder.Eval(Container.DataItem, "Status"))) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:ButtonField ButtonType = "Button" Text = "Select" CommandName = "Details"  />
        </Columns>
    </asp:GridView>
    <br />
    <asp:Button ID="btnSave" runat="server" Text="Print" onclick="BtnSave_Click" Visible="false"/>
    
    <%--TypeName="LabKitOrderManager" --%>
    <asp:ObjectDataSource ID="ObjectDataSourceLabKitOrders" runat="server" 
        SelectMethod="" 
        TypeName="VIRP_WEB.BaseCode.ServiceInterfaceManager"
        OnSelecting="Ds_Selecting"
        onselected="ObjectDataSource1_Selected" 
        SortParameterName="sort"
        StartRowIndexParameterName="startRow" 
        MaximumRowsParameterName="maxRows" 
        SelectCountMethod="GetKitsCount"
        EnablePaging="true">
        <SelectParameters> 
            <asp:ControlParameter Name = "lastName" 
                ControlID = "TextBoxSearchCriteria" DefaultValue = "" />
            <asp:ControlParameter Name = "facilityId" 
                ControlID = "DropDownListFacility" 
            propertyname="SelectedValue" DefaultValue = "" />
        </SelectParameters>     
   </asp:ObjectDataSource>
    <asp:ObjectDataSource ID="ObjectDataSourceVAMCs" runat="server" 
        SelectMethod="GetInsitutionList" 
        TypeName="VIRP_WEB.BaseCode.ServiceInterfaceManager"
        OnSelecting="Ds_Selecting">
    </asp:ObjectDataSource>    
</asp:Content>

